---
title: Changelog for managed rulesets · Cloudflare Web Application Firewall (WAF) docs
description: The WAF changelog provides information about changes to managed
  rulesets and general updates to WAF protection.
lastUpdated: 2025-09-26T16:00:48.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/change-log/
  md: https://developers.cloudflare.com/waf/change-log/index.md
---

The WAF changelog provides information about changes to managed rulesets and general updates to WAF protection.

## Changelog for managed rulesets

Cloudflare has a regular cadence of releasing updates and new rules to WAF managed rulesets. The updates either improve a rule's accuracy, lower false positives rates, or increase the protection due to a change in the threat landscape.

The release cycle for new rules happens on a 7-day cycle, typically every Monday or Tuesday depending on public holidays. For updates of existing rules, Cloudflare will initially deploy the updated rule as a `BETA` rule (denoted in rule description) and with a `beta` tag, before updating the original rule on the next release cycle. Cloudflare will deploy the updated or new rules into logging only mode (*Log* action), with `beta` and `new` tags. Most newly created rules will carry both the `beta` and `new` tags. Logging only mode allows you to identify any increases in security event volumes which look like potential false positives. On the following Monday (or Tuesday) the rules will change from logging only mode to the intended default action (**New Action** column in the changelog table), with the `beta` and `new` tags removed.

Cloudflare may also add rules on the same 7-day release cycle in disabled mode to make the remediation logic available to customers, who can activate the rule if needed. Having these rules in place allows Cloudflare to perform impact testing and performance checks without affecting traffic. These deactivated rules will not have the `beta` and `new` tags assigned to them.

Cloudflare is very proactive in responding to new vulnerabilities, which may need to be released outside of the 7-day cycle, defined as an Emergency Release.

Warning

[Ruleset overrides and tag overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) apply to existing and **future** rules in the managed ruleset, which includes changes in regular and emergency releases.

If you do notice a new or updated rule generating an increased volume of security events, you can disable or change the rule from its *Default* action. Once you change a rule to use an action other than the default one, Cloudflare will not be able to override the rule action.

[View scheduled changes](https://developers.cloudflare.com/waf/change-log/scheduled-changes/)

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/waf.xml)

## General updates

For more general updates to the WAF, refer to [general updates](https://developers.cloudflare.com/waf/change-log/general-updates/).
