---
title: Hostname management · Cloudflare Turnstile docs
description: You can associate hostnames with your widget to control where it
  can be used using Hostname Management. Managing your hostnames ensures that
  Turnstile works seamlessly with your setup, whether you add standalone
  hostnames or leverage zones registered to your Cloudflare account.
lastUpdated: 2025-09-04T15:24:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/additional-configuration/hostname-management/
  md: https://developers.cloudflare.com/turnstile/additional-configuration/hostname-management/index.md
---

You can associate hostnames with your widget to control where it can be used using Hostname Management. Managing your hostnames ensures that Turnstile works seamlessly with your setup, whether you add standalone hostnames or leverage zones registered to your Cloudflare account.

## Hostname limits

By default, a widget can have a maximum of 15 hostnames for Free users and 200 hostnames for Enterprise customers. Each widget requires at least one hostname to be entered. You will not be able to create the widget without a hostname configured.

### Availability

Customers with Enterprise Bot Management or Enterprise Turnstile may create and use a widget without entering any hostnames, or have up to 200 hostnames associated with a widget. Contact your account team for access to this feature.

## Add a custom hostname

You can add a hostname to your Turnstile widget even if it is not on the Cloudflare network or registered as a zone. There are no prerequisites for using Turnstile.

To add a custom hostname:

1. In the Cloudflare dashboard, go to the **Turnstile** page.

   [Go to **Turnstile**](https://dash.cloudflare.com/?to=/:account/turnstile)

2. On an existing widget, select **Settings**.

3. Select **Add Hostnames** under Hostname Management.

4. Add a custom hostname or choose from an existing hostname.

5. Select **Add**.

## Add hostnames with a registered zone

If you already have a zone registered with Cloudflare, you can add hostnames during the Turnstile widget setup. You will see all zones registered to your account, where you can select the relevant hostname from the list, and it will be added to your Turnstile widget seamlessly.

## Hostname requirements

Warning

Customers enabling [client-side rendering](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/) must validate their hostnames by looking at the [`hostname`](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/#:~:text=challenge%20was%20solved.-,hostname,-is%20the%20hostname) field in the Siteverify response.

When associating hostnames with a widget, follow these requirements:

* Hostnames must be fully qualified domain names (FQDNs), such as `example.com` or `subdomain.example.com`.

* Wildcards are not supported. Specify each hostname you want Turnstile to work on.

* The hostname should not include:

  * A scheme (for example, `http://` or `https://`)
  * A port (for example, `443`)
  * A path (for example, `/path`)

### Subdomain specification

Specifying a subdomain is optional, but it can be used to further restrict the widget. For example, adding `www.example.com` as a hostname will allow widgets to work on:

* `www.example.com`
* `abc.www.example.com:8080`

However, it will not work on the following hostnames:

* `example.com`
* `dash.example.com`
* `cloudflare.com`

Note

If the widget is embedded on a hostname not listed, it will display an error message.

## Optional hostname validation (Enterprise only)

Customers with Enterprise Bot Management or Enterprise Turnstile can have the optional `any hostname` validation entitlement.

By default, a widget requires at least one hostname to be entered. With this feature, you can create and use a widget without entering any hostnames for the widget.

Contact your account team to enable this feature.
