---
title: Manage and deploy your AI provider keys through Bring Your Own Key (BYOK)
  with AI Gateway, now powered by Cloudflare Secrets Store · Changelog
description: Cloudflare Secrets Store is now integrated with AI Gateway,
  allowing you to store, manage, and deploy your AI provider keys in a secure
  and seamless configuration through [Bring Your Own
  Key](https://developers.cloudflare.com/ai-gateway/configuration/bring-your-own-keys/).
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-08-25-secrets-store-ai-gateway/
  md: https://developers.cloudflare.com/changelog/2025-08-25-secrets-store-ai-gateway/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Manage and deploy your AI provider keys through Bring Your Own Key (BYOK) with AI Gateway, now powered by Cloudflare Secrets Store

Aug 25, 2025

[Secrets Store ](https://developers.cloudflare.com/secrets-store/)[AI Gateway ](https://developers.cloudflare.com/ai-gateway/)[SSL/TLS](https://developers.cloudflare.com/ssl/)

Cloudflare Secrets Store is now integrated with AI Gateway, allowing you to store, manage, and deploy your AI provider keys in a secure and seamless configuration through [Bring Your Own Key](https://developers.cloudflare.com/ai-gateway/configuration/bring-your-own-keys/). Instead of passing your AI provider keys directly in every request header, you can centrally manage each key with Secrets Store and deploy in your gateway configuration using only a reference, rather than passing the value in plain text.

You can now create a secret directly from your AI Gateway [in the dashboard](http://dash.cloudflare.com/?to=/:account/ai-gateway) by navigating into your gateway -> **Provider Keys** -> **Add**.

![Import repo or choose template](https://developers.cloudflare.com/_astro/add-secret-ai-gateway.B-SIPr6s_Z1Q2xOA.webp)

You can also create your secret with the newly available **ai\_gateway** scope via [wrangler](https://developers.cloudflare.com/workers/wrangler/commands/), the [Secrets Store dashboard](http://dash.cloudflare.com/?to=/:account/secrets-store), or the [API](https://developers.cloudflare.com/api/resources/secrets_store/).

Then, pass the key in the request header using its Secrets Store reference:

```plaintext
curl -X POST https://gateway.ai.cloudflare.com/v1/<ACCOUNT_ID>/my-gateway/anthropic/v1/messages \
 --header 'cf-aig-authorization: ANTHROPIC_KEY_1 \
 --header 'anthropic-version: 2023-06-01' \
 --header 'Content-Type: application/json' \
 --data  '{"model": "claude-3-opus-20240229", "messages": [{"role": "user", "content": "What is Cloudflare?"}]}'
```

Or, using Javascript:

```plaintext
import Anthropic from '@anthropic-ai/sdk';




const anthropic = new Anthropic({
 apiKey: "ANTHROPIC_KEY_1",
 baseURL: "https://gateway.ai.cloudflare.com/v1/<ACCOUNT_ID>/my-gateway/anthropic",
});




const message = await anthropic.messages.create({
 model: 'claude-3-opus-20240229',
 messages: [{role: "user", content: "What is Cloudflare?"}],
 max_tokens: 1024
});
```

For more information, check out the [blog](https://blog.cloudflare.com/ai-gateway-aug-2025-refresh)!
